<?php
include 'conexao.php';
$alunos = $conn->query("SELECT id, nome, idade, genero FROM alunos ORDER BY nome")->fetch_all(MYSQLI_ASSOC);
?>

<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <title>Lista de Alunos</title>
    <link rel="stylesheet" href="estilo_sismag.css">
    <style>
        body {
            margin: 0;
            font-family: Arial, sans-serif;
            background: #f8f9fa;
        }
        .container {
            margin-left: 250px;
            padding: 20px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            background: white;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        table th, table td {
            padding: 12px;
            text-align: left;
            border-bottom: 1px solid #ccc;
        }
        table th {
            background: #004080;
            color: white;
        }
    </style>
</head>
<body>



<div class="container">
    <h2>Lista de Alunos Cadastrados</h2>
    <table>
        <thead>
            <tr>
                <th>#</th>
                <th>Nome</th>
                <th>Idade</th>
                <th>Género</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($alunos as $i => $aluno): ?>
            <tr>
                <td><?= $i + 1 ?></td>
                <td><?= $aluno['nome'] ?></td>
                <td><?= $aluno['idade'] ?></td>
                <td><?= $aluno['genero'] ?></td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>

</body>
</html>
